IF OBJECT_ID('V_EST_PED_VD_IT_FISCAL') IS NOT NULL 
BEGIN
	DROP VIEW V_EST_PED_VD_IT_FISCAL
END

GO
GO

CREATE VIEW
	V_EST_PED_VD_IT_FISCAL
AS
SELECT
	IT.CD_EMP,
	IT.CD_FILIAL,
	IT.CD_PED,
	IT.CD_PROD,
	IT.QT_IT,
	ROUND(IT.VLR_TOT_IT / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_TOT_IT,
	IT.ALIQ_ICMS,
	ROUND(COALESCE(IT.VLR_BASE_ICMS_IT, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_BASE_ICMS_IT,
	ROUND(COALESCE(IT.VLR_ICMS_IT, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_ICMS_IT,
	ROUND(COALESCE(IT.VLR_BASE_ICMS_SUBS, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_BASE_ICMS_SUBS,
	ROUND(COALESCE(IT.VLR_ICMS_SUBS, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_ICMS_SUBS,
	    
	COALESCE(IT.PERC_REDU_BASE_ICMS, 0) AS PERC_REDU_BASE_ICMS,
	COALESCE(IT.PERC_REDU_BASE_SUBS, 0) AS PERC_REDU_BASE_SUBS,
	ROUND(COALESCE(IT.VLR_BASE_ICMS_RET, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_BASE_ICMS_RET,
	ROUND(COALESCE(IT.VLR_ICMS_RETIDO, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_ICMS_RETIDO,
	ROUND(COALESCE(IT.VLR_OUTROS_DESPESAS, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_OUTROS_DESPESAS,
	ROUND(COALESCE(IT.VLR_IMPOSTO_REA, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_IMPOSTO_REA,
	ROUND(COALESCE(IT.VLR_BASE_ICMS_OP, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_BASE_ICMS_OP,
	ROUND(COALESCE(IT.VLR_ICMS_OP, 0) / CASE WHEN IT.QT_IT = 0 THEN 1 ELSE IT.QT_IT END, 2) AS VLR_ICMS_OP,
	COALESCE(IT.PERC_ICMS_OP, 0) AS PERC_ICMS_OP    
FROM
	EST_PED_VD_IT IT
	
